import * as React from "react";
import { cn } from "@/lib/utils";

export interface ButtonProps extends React.ButtonHTMLAttributes<HTMLButtonElement> {
  variant?: 'default' | 'secondary' | 'outline' | 'ghost';
  size?: 'default' | 'sm' | 'lg';
}

export const Button = React.forwardRef<HTMLButtonElement, ButtonProps>(
  ({ className, variant = 'default', size = 'default', ...props }, ref) => {
    return (
      <button
        className={cn(
          // Base styles
          "inline-flex items-center justify-center rounded-md font-medium transition-colors focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring disabled:pointer-events-none disabled:opacity-50",
          
          // Variant styles
          variant === 'default' && "bg-primary text-primary-foreground hover:bg-primary/90",
          variant === 'secondary' && "bg-secondary text-secondary-foreground hover:bg-secondary/90",
          variant === 'outline' && "border border-primary bg-transparent text-primary hover:bg-primary/10",
          variant === 'ghost' && "hover:bg-accent hover:text-accent-foreground",
          
          // Size styles
          size === 'default' && "h-10 px-4 py-2",
          size === 'sm' && "h-8 px-3 text-sm",
          size === 'lg' && "h-12 px-6 text-lg",
          
          className
        )}
        ref={ref}
        {...props}
      />
    );
  }
);
