import Link from 'next/link';
import { Button } from '../ui/button';

export default function Header() {
  return (
    <header className="bg-white shadow-sm">
      <div className="corpcare-container py-4">
        <div className="flex items-center justify-between">
          <div className="flex items-center">
            <Link href="/" className="text-2xl font-bold text-primary">
              CorpCare
            </Link>
          </div>
          
          <nav className="hidden md:flex space-x-8">
            <Link href="/solucoes" className="text-gray-700 hover:text-primary transition-colors">
              Soluções
            </Link>
            <Link href="/tecnologia" className="text-gray-700 hover:text-primary transition-colors">
              Tecnologia
            </Link>
            <Link href="/beneficios" className="text-gray-700 hover:text-primary transition-colors">
              Benefícios
            </Link>
            <Link href="/modelo-de-negocios" className="text-gray-700 hover:text-primary transition-colors">
              Modelo de Negócios
            </Link>
            <Link href="/sobre" className="text-gray-700 hover:text-primary transition-colors">
              Sobre Nós
            </Link>
          </nav>
          
          <div>
            <Button className="corpcare-button">
              Fale com Especialistas
            </Button>
          </div>
        </div>
      </div>
    </header>
  );
}
