import Link from 'next/link';

export default function Footer() {
  return (
    <footer className="bg-primary text-primary-foreground">
      <div className="corpcare-container py-12">
        <div className="grid grid-cols-1 md:grid-cols-4 gap-8">
          <div>
            <h3 className="text-xl font-bold mb-4">CorpCare</h3>
            <p className="text-sm">
              Transformando a gestão de saúde em empresas, maximizando a produtividade dos funcionários através de um cuidado de saúde proativo e personalizado.
            </p>
          </div>
          
          <div>
            <h3 className="text-lg font-semibold mb-4">Soluções</h3>
            <ul className="space-y-2">
              <li><Link href="/solucoes#gestao" className="text-sm hover:underline">Gestão de Saúde Corporativa</Link></li>
              <li><Link href="/solucoes#telemedicina" className="text-sm hover:underline">Telemedicina e Telemonitoramento</Link></li>
              <li><Link href="/solucoes#beneficios" className="text-sm hover:underline">Benefícios CorpCare</Link></li>
            </ul>
          </div>
          
          <div>
            <h3 className="text-lg font-semibold mb-4">Empresa</h3>
            <ul className="space-y-2">
              <li><Link href="/sobre" className="text-sm hover:underline">Sobre Nós</Link></li>
              <li><Link href="/modelo-de-negocios" className="text-sm hover:underline">Modelo de Negócios</Link></li>
              <li><Link href="/tecnologia" className="text-sm hover:underline">Nossa Tecnologia</Link></li>
            </ul>
          </div>
          
          <div>
            <h3 className="text-lg font-semibold mb-4">Contato</h3>
            <ul className="space-y-2">
              <li className="text-sm">contato@corpcare.com.br</li>
              <li className="text-sm">+55 (11) 9999-9999</li>
              <li><Link href="/contato" className="text-sm hover:underline">Fale Conosco</Link></li>
            </ul>
          </div>
        </div>
        
        <div className="border-t border-primary-foreground/20 mt-8 pt-8 flex flex-col md:flex-row justify-between items-center">
          <p className="text-sm">&copy; {new Date().getFullYear()} CorpCare. Todos os direitos reservados.</p>
          <div className="flex space-x-4 mt-4 md:mt-0">
            <Link href="/privacidade" className="text-sm hover:underline">Política de Privacidade</Link>
            <Link href="/termos" className="text-sm hover:underline">Termos de Uso</Link>
          </div>
        </div>
      </div>
    </footer>
  );
}
