import React from 'react';

export default function TechnologySection() {
  return (
    <section className="corpcare-section bg-white">
      <div className="corpcare-container">
        <h2 className="corpcare-heading text-center mb-12">Tecnologia para a Saúde</h2>
        
        <div className="mb-10">
          <p className="text-center text-lg mb-8">
            Através de plataforma tecnológica proprietária, o cuidado dos funcionários
            estará muito mais sob o controle da empresa
          </p>
        </div>
        
        <div className="grid grid-cols-1 md:grid-cols-2 gap-8">
          <div className="corpcare-card">
            <h3 className="corpcare-subheading mb-4">Atendimento Online</h3>
            <p className="text-gray-700">
              Serviço de atendimento à saúde personalizado e online para os funcionários,
              garantindo acesso rápido e eficiente a cuidados médicos de qualidade.
            </p>
          </div>
          
          <div className="corpcare-card">
            <h3 className="corpcare-subheading mb-4">Abordagem Personalizada</h3>
            <p className="text-gray-700">
              A personalização do cuidado baseada em tecnologia trará mais segurança e 
              satisfação aos funcionários, adaptando-se às necessidades específicas de cada um.
            </p>
          </div>
          
          <div className="corpcare-card">
            <h3 className="corpcare-subheading mb-4">Escalabilidade</h3>
            <p className="text-gray-700">
              O uso de tecnologia e telemedicina permite a ampliação rápida e sem limitações 
              da capacidade de atendimento, atendendo empresas de todos os portes.
            </p>
          </div>
          
          <div className="corpcare-card">
            <h3 className="corpcare-subheading mb-4">Sustentabilidade</h3>
            <p className="text-gray-700">
              Redução do uso de papel, foco em saúde preventiva e saúde mental, 
              além de garantir tratamento igualitário para todos os funcionários.
            </p>
          </div>
        </div>
      </div>
    </section>
  );
}
