import React from 'react';

export default function SolutionsSection() {
  return (
    <section className="corpcare-section bg-secondary/20">
      <div className="corpcare-container">
        <h2 className="corpcare-heading text-center mb-12">Nossas Soluções</h2>
        
        <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
          <div className="corpcare-card bg-white">
            <h3 className="corpcare-subheading mb-4">Gestão de Saúde Corporativa</h3>
            <ul className="space-y-2 text-gray-700">
              <li className="flex items-start">
                <span className="text-primary font-bold mr-2">•</span>
                <span>Análise detalhada da sinistralidade dos planos de saúde</span>
              </li>
              <li className="flex items-start">
                <span className="text-primary font-bold mr-2">•</span>
                <span>Implementação de programas de saúde preventiva e bem-estar</span>
              </li>
              <li className="flex items-start">
                <span className="text-primary font-bold mr-2">•</span>
                <span>Monitoramento contínuo da saúde dos funcionários</span>
              </li>
            </ul>
          </div>
          
          <div className="corpcare-card bg-white">
            <h3 className="corpcare-subheading mb-4">Telemedicina e Telemonitoramento</h3>
            <ul className="space-y-2 text-gray-700">
              <li className="flex items-start">
                <span className="text-primary font-bold mr-2">•</span>
                <span>Consultas remotas e monitoramento de condições de saúde em tempo real</span>
              </li>
              <li className="flex items-start">
                <span className="text-primary font-bold mr-2">•</span>
                <span>Suporte médico contínuo através de aplicativos e dispositivos móveis</span>
              </li>
              <li className="flex items-start">
                <span className="text-primary font-bold mr-2">•</span>
                <span>Atendimento local e point-of-care</span>
              </li>
            </ul>
          </div>
          
          <div className="corpcare-card bg-white">
            <h3 className="corpcare-subheading mb-4">Benefícios CorpCare</h3>
            <ul className="space-y-2 text-gray-700">
              <li className="flex items-start">
                <span className="text-primary font-bold mr-2">•</span>
                <span>Parcerias com redes de saúde para oferecer serviços a preços reduzidos</span>
              </li>
              <li className="flex items-start">
                <span className="text-primary font-bold mr-2">•</span>
                <span>Programas de nutrição, fitness e saúde mental</span>
              </li>
              <li className="flex items-start">
                <span className="text-primary font-bold mr-2">•</span>
                <span>Campanhas de vacinação e check-ups regulares</span>
              </li>
            </ul>
          </div>
        </div>
      </div>
    </section>
  );
}
