import React from 'react';

export default function ProblemsSection() {
  return (
    <section className="corpcare-section bg-white">
      <div className="corpcare-container">
        <h2 className="corpcare-heading text-center mb-12">Problemas do Sistema Atual</h2>
        
        <div className="grid grid-cols-1 md:grid-cols-2 gap-8">
          <div className="corpcare-card">
            <h3 className="corpcare-subheading mb-4">Acesso Limitado a Serviços de Saúde</h3>
            <p className="text-gray-700">
              A falta de acesso a cuidados preventivos e check-ups leva a emergências médicas e tratamentos
              caros, aumentando os custos de saúde das empresas. Por outro lado há desperdício com
              exames desnecessários.
            </p>
          </div>
          
          <div className="corpcare-card">
            <h3 className="corpcare-subheading mb-4">Coordenação Fragmentada dos Cuidados</h3>
            <p className="text-gray-700">
              A comunicação ineficaz entre diferentes provedores de saúde resulta em redundâncias,
              erros médicos e tratamentos ineficazes, elevando os custos para as empresas.
            </p>
          </div>
          
          <div className="corpcare-card">
            <h3 className="corpcare-subheading mb-4">Falhas na Gestão de Doenças Crônicas</h3>
            <p className="text-gray-700">
              A gestão inadequada de doenças crônicas como diabetes e hipertensão pode levar a complicações
              graves, hospitalizações frequentes e aumento dos custos médicos para as empresas.
            </p>
          </div>
          
          <div className="corpcare-card">
            <h3 className="corpcare-subheading mb-4">Estigma e Acessibilidade da Saúde Mental</h3>
            <p className="text-gray-700">
              O estigma associado à saúde mental impede os funcionários de buscar tratamento precoce,
              resultando em problemas mais graves e altos custos com tratamentos prolongados.
            </p>
          </div>
        </div>
      </div>
    </section>
  );
}
