import { Button } from '../ui/button';

export default function HeroSection() {
  return (
    <section className="bg-gradient-to-r from-primary/10 to-secondary/30 py-16 md:py-24">
      <div className="corpcare-container">
        <div className="grid grid-cols-1 md:grid-cols-2 gap-12 items-center">
          <div>
            <h1 className="text-4xl md:text-5xl lg:text-6xl font-bold text-primary mb-6">
              Transformando a Gestão de Saúde Corporativa
            </h1>
            <p className="text-lg mb-8">
              Soluções integradas que diminuem a sinistralidade dos planos de saúde corporativos, 
              reduzindo custos, diminuindo a ausência por doenças e melhorando a produtividade 
              dos funcionários através de um modelo de saúde preventiva e gestão eficaz da saúde.
            </p>
            <div className="flex flex-col sm:flex-row gap-4">
              <Button className="corpcare-button text-lg py-3 px-6">
                Fale com Especialistas
              </Button>
              <Button className="corpcare-button-secondary text-lg py-3 px-6">
                Conheça Nossas Soluções
              </Button>
            </div>
          </div>
          <div className="flex justify-center">
            <div className="bg-white p-6 rounded-lg shadow-xl border border-primary/20 max-w-md">
              <h2 className="text-2xl font-bold text-primary mb-4">Nosso Mercado</h2>
              <p className="mb-4">
                Os custos dos planos empresariais de saúde no Brasil superaram a média mundial, 
                e as operadoras devem reajustar o preço em cerca de 25% em 2024, afetando cerca 
                de 41 milhões de pessoas.
              </p>
              <div className="bg-secondary/30 p-4 rounded-md">
                <p className="font-semibold">
                  61% das pessoas mudariam de emprego por causa especificamente do benefício de saúde.
                </p>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
}
