import React from 'react';
import { Button } from '../ui/button';

export default function BusinessModelSection() {
  return (
    <section className="corpcare-section bg-secondary/20">
      <div className="corpcare-container">
        <h2 className="corpcare-heading text-center mb-12">Modelo de Negócios</h2>
        
        <div className="grid grid-cols-1 md:grid-cols-2 gap-8 mb-12">
          <div className="corpcare-card bg-white">
            <h3 className="corpcare-subheading mb-4">Estratégia de Receitas</h3>
            <ul className="space-y-4 text-gray-700">
              <li>
                <p className="font-semibold">Assinatura: Assinaturas Mensais</p>
                <p>Empresas pagam uma taxa fixa mensal para acessar os serviços de gestão de saúde integrados.</p>
              </li>
              <li>
                <p className="font-semibold">Fee-for-Service (para Serviços Adicionais)</p>
                <p>Cobranças por consultas adicionais, tratamentos especiais e serviços personalizados.</p>
              </li>
            </ul>
          </div>
          
          <div className="corpcare-card bg-white">
            <h3 className="corpcare-subheading mb-4">Estrutura de Preços</h3>
            <ul className="space-y-4 text-gray-700">
              <li>
                <p className="font-semibold">Plano Básico</p>
                <p>Inclui serviços essenciais de gestão de saúde e telemedicina. Ideal para pequenas e médias empresas.</p>
              </li>
              <li>
                <p className="font-semibold">Plano Avançado</p>
                <p>Inclui todos os serviços do plano básico, além de programas personalizados de bem-estar e acesso ao cartão de benefícios CorpCare.</p>
              </li>
              <li>
                <p className="font-semibold">Plano Premium</p>
                <p>Inclui todos os serviços do plano avançado, com adição de monitoramento contínuo de saúde e suporte prioritário.</p>
              </li>
            </ul>
          </div>
        </div>
        
        <div className="grid grid-cols-1 md:grid-cols-2 gap-8">
          <div className="corpcare-card bg-white">
            <h3 className="corpcare-subheading mb-4">Parcerias Estratégicas</h3>
            <ul className="space-y-2 text-gray-700">
              <li className="flex items-start">
                <span className="text-primary font-bold mr-2">•</span>
                <span>Provedores de Saúde: Parcerias com prestadores para atenção diferenciada</span>
              </li>
              <li className="flex items-start">
                <span className="text-primary font-bold mr-2">•</span>
                <span>Redes de Farmácias: Acordos com farmácias para proporcionar descontos em medicamentos e produtos de saúde</span>
              </li>
              <li className="flex items-start">
                <span className="text-primary font-bold mr-2">•</span>
                <span>Tecnologia: Colaborações com parceiros comerciais para melhorar a plataforma de telemedicina e monitoramento remoto</span>
              </li>
            </ul>
          </div>
          
          <div className="corpcare-card bg-white">
            <h3 className="corpcare-subheading mb-4">Proposta de Valor</h3>
            <ul className="space-y-2 text-gray-700">
              <li className="flex items-start">
                <span className="text-primary font-bold mr-2">•</span>
                <span>Redução de Custos: Implementação de programas de saúde preventiva e gestão eficaz de doenças crônicas</span>
              </li>
              <li className="flex items-start">
                <span className="text-primary font-bold mr-2">•</span>
                <span>Aumento de Produtividade: Melhoria na saúde dos funcionários, reduzindo o absenteísmo</span>
              </li>
              <li className="flex items-start">
                <span className="text-primary font-bold mr-2">•</span>
                <span>Acesso a Cuidados de Qualidade: Acesso facilitado através do cartão de benefícios CorpCare</span>
              </li>
            </ul>
          </div>
        </div>
        
        <div className="mt-12 text-center">
          <Button className="corpcare-button">
            Conheça Nossos Planos
          </Button>
        </div>
      </div>
    </section>
  );
}
