import { Button } from '@/components/ui/button';

export function ButtonVariants() {
  return (
    <div className="flex flex-col gap-4">
      <div className="flex flex-wrap gap-4">
        <Button className="corpcare-button">Botão Primário</Button>
        <Button className="corpcare-button-secondary">Botão Secundário</Button>
        <Button className="bg-white text-primary border border-primary hover:bg-primary/10">
          Botão Outline
        </Button>
      </div>
    </div>
  );
}

export function ColorPalette() {
  return (
    <div className="grid grid-cols-2 md:grid-cols-4 gap-4">
      <div className="flex flex-col">
        <div className="h-20 bg-primary rounded-t-md"></div>
        <div className="bg-white p-2 rounded-b-md border border-gray-200">
          <p className="font-semibold">Primária</p>
          <p className="text-xs text-gray-500">Verde</p>
        </div>
      </div>
      
      <div className="flex flex-col">
        <div className="h-20 bg-secondary rounded-t-md"></div>
        <div className="bg-white p-2 rounded-b-md border border-gray-200">
          <p className="font-semibold">Secundária</p>
          <p className="text-xs text-gray-500">Bege</p>
        </div>
      </div>
      
      <div className="flex flex-col">
        <div className="h-20 bg-accent rounded-t-md"></div>
        <div className="bg-white p-2 rounded-b-md border border-gray-200">
          <p className="font-semibold">Accent</p>
          <p className="text-xs text-gray-500">Verde Claro</p>
        </div>
      </div>
      
      <div className="flex flex-col">
        <div className="h-20 bg-gray-700 rounded-t-md"></div>
        <div className="bg-white p-2 rounded-b-md border border-gray-200">
          <p className="font-semibold">Texto</p>
          <p className="text-xs text-gray-500">Cinza Escuro</p>
        </div>
      </div>
    </div>
  );
}

export function TypographyShowcase() {
  return (
    <div className="space-y-4">
      <div>
        <h1 className="corpcare-heading">Título Principal (H1)</h1>
        <p className="text-sm text-gray-500">corpcare-heading</p>
      </div>
      
      <div>
        <h2 className="corpcare-subheading">Subtítulo (H2)</h2>
        <p className="text-sm text-gray-500">corpcare-subheading</p>
      </div>
      
      <div>
        <h3 className="text-xl font-semibold text-gray-800">Título de Seção (H3)</h3>
        <p className="text-sm text-gray-500">text-xl font-semibold</p>
      </div>
      
      <div>
        <p className="text-base text-gray-700">Texto de parágrafo padrão com tamanho base.</p>
        <p className="text-sm text-gray-500">text-base</p>
      </div>
      
      <div>
        <p className="text-sm text-gray-600">Texto menor para informações secundárias.</p>
        <p className="text-sm text-gray-500">text-sm</p>
      </div>
    </div>
  );
}

export default function StyleGuide() {
  return (
    <div className="corpcare-container py-12">
      <h1 className="corpcare-heading mb-8">Guia de Estilo CorpCare</h1>
      
      <section className="mb-12">
        <h2 className="corpcare-subheading mb-4">Paleta de Cores</h2>
        <ColorPalette />
      </section>
      
      <section className="mb-12">
        <h2 className="corpcare-subheading mb-4">Tipografia</h2>
        <TypographyShowcase />
      </section>
      
      <section className="mb-12">
        <h2 className="corpcare-subheading mb-4">Botões</h2>
        <ButtonVariants />
      </section>
      
      <section className="mb-12">
        <h2 className="corpcare-subheading mb-4">Cartões</h2>
        <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
          <div className="corpcare-card">
            <h3 className="text-xl font-semibold text-primary mb-2">Cartão Padrão</h3>
            <p className="text-gray-700">Este é um exemplo de cartão padrão utilizado no site da CorpCare.</p>
          </div>
          
          <div className="corpcare-card bg-secondary/20">
            <h3 className="text-xl font-semibold text-primary mb-2">Cartão com Fundo</h3>
            <p className="text-gray-700">Este é um exemplo de cartão com fundo colorido.</p>
          </div>
        </div>
      </section>
    </div>
  );
}
