import HeroSection from '@/components/home/HeroSection';
import ProblemsSection from '@/components/home/ProblemsSection';
import SolutionsSection from '@/components/home/SolutionsSection';
import TechnologySection from '@/components/home/TechnologySection';
import BusinessModelSection from '@/components/home/BusinessModelSection';
import { Button } from '@/components/ui/button';

export default function Home() {
  return (
    <main>
      <HeroSection />
      <ProblemsSection />
      <SolutionsSection />
      <TechnologySection />
      <BusinessModelSection />
      
      <section className="corpcare-section bg-primary text-primary-foreground">
        <div className="corpcare-container text-center">
          <h2 className="text-3xl md:text-4xl font-bold mb-6">Vamos transformar a gestão de saúde da sua empresa</h2>
          <p className="text-lg mb-8 max-w-3xl mx-auto">
            Entre em contato com nossos especialistas e descubra como a CorpCare pode ajudar sua empresa 
            a reduzir custos, aumentar a produtividade e melhorar a saúde dos seus funcionários.
          </p>
          <Button className="bg-white text-primary hover:bg-white/90 text-lg py-3 px-6">
            Fale com Especialistas
          </Button>
        </div>
      </section>
    </main>
  );
}
