import Header from '@/components/layout/Header';
import Footer from '@/components/layout/Footer';
import { Button } from '@/components/ui/button';

export default function RootLayout({
  children,
}: {
  children: React.ReactNode;
}) {
  return (
    <html lang="pt-BR">
      <head>
        <title>CorpCare - Transformando a Gestão de Saúde Corporativa</title>
        <meta name="description" content="Soluções integradas que diminuem a sinistralidade dos planos de saúde corporativos, reduzindo custos e melhorando a produtividade dos funcionários." />
      </head>
      <body>
        <Header />
        {children}
        <Footer />
      </body>
    </html>
  );
}
